// GpPenEscA.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscA Dialog


CGpPenEscA::CGpPenEscA(CWnd* pParent /*=NULL*/)
	:CIndecateArc(CGpPenEscA::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscA)
	m_cLineStyle = 0;
	//}}AFX_DATA_INIT

	m_enArcAction = B_bAction_OFF ;
	Create(IDD,pParent);
}


void CGpPenEscA::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscA)
	DDX_CBIndex(pDX, IDC_cLineStyle, m_cLineStyle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscA, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscA)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGpPenEscA Message Handler

void CGpPenEscA::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}


// Create Content
CContents*  CGpPenEscA::CreateContents()
{
	// Create empty content
	CContentsEscA* pContents = new CContentsEscA();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Line Style
	pContents->m_Data.cLineStyle = m_cLineStyle ;
	if( pContents->m_Data.cLineStyle > 3 )
	{
		pContents->m_Data.cLineStyle += 4 ;
	}


	// Set Content the display position
	pContents->m_Data.iX1         = m_iX1 ;			// Center position for circle
	pContents->m_Data.iY1         = m_iY1 ;			// Center position for circle
	pContents->m_Data.iRadius     = m_iRadius ;		// Radius for circle
	pContents->m_Data.iStartAngle = m_iSd ;			// Start angle for circle
	pContents->m_Data.iEndAngle   = m_iEd ;			// End angle for circle

	return( pContents );
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Draw Circle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecateArc::ActionErase(CDC* pDC)
{

	switch( m_enArcAction ){
		case B_bAction_1:	// begin -> select
			InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
			InvertLine(pDC,m_StartPoint.x,m_StartPoint.y,m_iX1,m_iY1);
			break ;

		case  B_bAction_2:	// Select position
			InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius+15,m_iStartAngle) ;
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius+15,m_iEndAngle) ;
			break ;

		case  B_bAction_3:	// Select End angle
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius,m_iStartAngle) ;
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius,m_iEndAngle) ;
			InvertArc(pDC,m_iX1,m_iY1,m_iRadius,m_iSd,m_iEd) ;
			break ;

		default:	//	bug
			ASSERT( 0 ) ;
			break ;
	}
}

// Draw
void CIndecateArc::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	double dx,dy,dr ;
	int a ;

	switch( m_enArcAction ){
		case B_bAction_1:	// begin -> select
			m_iX1 = NewPoint.x ;
			m_iY1 = NewPoint.y ;
			dx = m_iX1 - m_StartPoint.x ;
			dy = m_iY1 - m_StartPoint.y ;
			dr = dx * dx + dy * dy ;
			m_iRadius = (int )sqrt(dr) ;
			InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
			InvertLine(pDC,m_StartPoint.x,m_StartPoint.y,m_iX1,m_iY1);
			break ;

		case  B_bAction_2:	// Select position
			InvertCircle(pDC,m_iX1,m_iY1,m_iRadius) ;
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius+15,m_iStartAngle) ;
			if(  !GetLineAngle(NewPoint.x,NewPoint.y,m_iX1,m_iY1,&m_iEndAngle) ){
				m_iEndAngle = m_iStartAngle ; // Angle is unknown
			}
			a = m_iEndAngle - m_iStartAngle ;
			if( a < 0 )
				a += 360 ;
			m_Direction = ( a > 180) ? B_Direction_RIGHT : B_Direction_LEFT ;
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius+15,m_iEndAngle) ;
			break ;


		case  B_bAction_3:	// Select End angle
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius,m_iStartAngle) ;
			if(  !GetLineAngle(NewPoint.x,NewPoint.y,m_iX1,m_iY1,&m_iEndAngle) ){
				m_iEndAngle = m_iStartAngle ; // Angle is unknown
			}
			InvertAngleLine(pDC,m_iX1,m_iY1,m_iRadius,m_iEndAngle) ;
			DirectionCheck(m_iStartAngle,m_iEndAngle,m_Direction,&m_iSd,&m_iEd );
			InvertArc(pDC,m_iX1,m_iY1,m_iRadius,m_iSd,m_iEd) ;
			break ;


		default:	//	bug
			ASSERT( 0 ) ;
			break ;
			
	}
}


// Begin Draw
int  CIndecateArc::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{

	switch( m_enArcAction ){
		case B_bAction_OFF:		// Not yet
			m_StartPoint = point ;
			m_iX1 = point.x ;
			m_iY1 = point.y ;
			m_enArcAction = B_bAction_1 ;	// begin -> select
			ActionDisplay(point,pDC) ;
			break ;
			
		case B_bAction_2:				// Select position
			ActionErase(pDC);
			m_enArcAction = B_bAction_3 ;	// Select angle
			ActionDisplay(point,pDC) ;
			break ;

		default:
			m_enArcAction = B_bAction_OFF ;
			return( B_ActionStop );	//	bug
	}
	return( B_ActionContinue );	// continue
}


// Move
int  CIndecateArc::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionErase(pDC) ;
	ActionDisplay(point,pDC) ;
	return( B_ActionContinue );	// Continue
}

// End
int  CIndecateArc::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionErase(pDC) ;

	switch( m_enArcAction ){
		case B_bAction_1:	// begin -> select
			// Start angle
			if(  !GetLineAngle(m_StartPoint.x,m_StartPoint.y,m_iX1,m_iY1,&m_iStartAngle) ){
				m_enArcAction = B_bAction_OFF ;
				return( B_ActionStop );
			}
			m_enArcAction = B_bAction_2 ;
			ActionDisplay(point,pDC) ;
			return( B_ActionContinue );
	
		case B_bAction_3:	// begin -> select
			// End Angle
			if(  !GetLineAngle(point.x,point.y,m_iX1,m_iY1,&m_iEndAngle) ){
				m_enArcAction = B_bAction_OFF ;
				return( B_ActionStop );
			}
			DirectionCheck(m_iStartAngle,m_iEndAngle,m_Direction,&m_iStartAngle,&m_iEndAngle );
			break ;

		default:
			m_enArcAction = B_bAction_OFF ;
			return( B_ActionStop );	//	bug
	}
	m_enArcAction = B_bAction_OFF ;
	return( B_ActionOk );
}

// Cancel
int  CIndecateArc::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	m_enArcAction = B_bAction_OFF ;
	return( B_ActionStop );
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////
// Get begin and end angle
//	Note : Angle is 0 to 360
//	
int GetLineAngle(int x1,int y1,int x2,int y2,int* ans)
{
	int dx = x1 - x2 ;
	int dy = y1 - y2 ;

	if( dx || dy ){

		double a ;
		int ia ;

		a = atan2((double )-dy,(double )dx) ;

		ia = (int )DEG(a) ;
		*ans = ( ia < 0 ) ? ia + 360 : ia ;
		return TRUE ;
	} else {
		return FALSE ;
	}
}

//	change to angle that GP supported
// 
//	GP support only draw to left
// 
void DirectionCheck(int iStartAngle,int iEndAngle,int iDirection,int* piStartAngle,int* piEndAngle )
{
	if( iDirection == B_Direction_LEFT ){
		// left : Same as GP
		*piStartAngle = iStartAngle ;
		*piEndAngle   = iEndAngle ;
	} else {
		// right : Not same as GP
		*piStartAngle = iEndAngle ;
		*piEndAngle   = iStartAngle ;
	}
}
